/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.server.IPECommands;
import java.io.Serializable;

public class VWParticipant
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7460L;
    public static final int PARTICIPANT_TYPE_UNDEFINED = 0;
    public static final int PARTICIPANT_TYPE_USER = 1;
    public static final int PARTICIPANT_TYPE_GROUP = 2;
    protected String m_participantName = null;
    protected String m_distinguishedName = null;
    protected String m_displayName = null;
    protected String m_guid = null;
    protected long m_userId = -1L;
    protected String m_secDomainName = null;
    protected int m_type = 0;
    private boolean m_bVerified = false;
    protected IPECommands m_cmdSession = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-22 22:05:46 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    public VWParticipant() {
    }

    public VWParticipant(String theParticipantName) {
        this.m_participantName = theParticipantName;
    }

    protected VWParticipant(String theParticipantName, int theUserID, String theDisplayName) {
        this.m_participantName = theParticipantName;
        this.m_userId = theUserID;
        this.m_displayName = theDisplayName;
    }

    protected VWParticipant(String theDomainName, String theParticipantName, String theDistinguishedName, String theDisplayName, String theGUID, long theUserID, int theType) {
        this.m_participantName = theParticipantName;
        this.m_distinguishedName = theDistinguishedName;
        this.m_displayName = theDisplayName;
        this.m_guid = theGUID;
        this.m_userId = theUserID;
        this.m_type = theType;
        this.m_secDomainName = theDomainName;
        this.m_bVerified = true;
    }

    public boolean isVerified() {
        if (!this.m_bVerified) {
            this.fillInFromCEMP();
        }
        return this.m_bVerified;
    }

    public Object clone() {
        try {
            VWParticipant px = (VWParticipant)super.clone();
            return px;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void fillInFromCEMP() {
        if (this.m_cmdSession != null) {
            String[] myDude = new String[]{this.m_participantName};
            long rpcArgBitMask = 131073L;
            VWParticipant myDetails = null;
            try {
                myDetails = this.m_cmdSession.fetchParticipants("", myDude, rpcArgBitMask)[0];
                this.m_distinguishedName = myDetails.m_distinguishedName;
                this.m_displayName = myDetails.m_displayName;
                this.m_guid = myDetails.m_guid;
                this.m_type = myDetails.m_type == 2 ? 2 : 1;
                this.m_type = myDetails.m_type;
                this.m_secDomainName = myDetails.m_secDomainName;
                this.m_bVerified = myDetails.m_bVerified;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private void fillInFromPE(boolean resolveId) {
        if (this.m_cmdSession != null) {
            String[] myDude = new String[]{this.m_participantName};
            try {
                this.m_userId = this.m_cmdSession.convertSecurityNamestoIds(myDude, resolveId)[0];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected String getPersistentName() {
        return this.m_participantName;
    }

    public String getParticipantName() {
        return this.m_participantName;
    }

    public void setParticipantName(String theParticipantName) {
        this.m_participantName = theParticipantName;
    }

    public String toString() {
        return this.m_participantName;
    }

    public String getDistinguishedName() {
        if (this.m_distinguishedName == null) {
            this.fillInFromCEMP();
        }
        if (this.m_distinguishedName != null && this.m_distinguishedName.length() > 0) {
            return this.m_distinguishedName;
        }
        return this.m_participantName;
    }

    protected void setDistinguishedName(String theDistinguishedName) {
        this.m_distinguishedName = theDistinguishedName;
    }

    public String getDisplayName() {
        if (this.m_displayName == null) {
            this.fillInFromCEMP();
        }
        return this.m_displayName;
    }

    protected void setDisplayName(String theDisplayName) {
        this.m_displayName = theDisplayName;
    }

    public String getGUID() {
        if (this.m_guid == null) {
            this.fillInFromCEMP();
        }
        return this.m_guid;
    }

    protected void setGUID(String theGUID) {
        this.m_guid = theGUID;
    }

    public long getUserId() {
        if (this.m_userId == -1L || this.m_userId == 0L) {
            this.fillInFromPE(false);
        }
        return this.m_userId;
    }

    protected long getUserId(boolean resolveId) {
        if (this.m_userId == -1L || this.m_userId == 0L || this.m_userId == 9L) {
            this.fillInFromPE(resolveId);
        }
        return this.m_userId;
    }

    protected void setUserId(int theUserId) {
        this.m_userId = theUserId;
    }

    public String getDomainName() {
        if (this.m_secDomainName == null) {
            this.fillInFromCEMP();
        }
        return this.m_secDomainName;
    }

    protected void setDomainName(String theDomainName) {
        this.m_secDomainName = theDomainName;
    }

    public boolean isGroup() {
        if (this.m_type == 0) {
            this.fillInFromCEMP();
        }
        return this.m_type == 2;
    }

    protected void setType(int theType) {
        this.m_type = theType;
    }

    protected void setCommandSession(IPECommands cmdSession) {
        this.m_cmdSession = cmdSession;
    }

    protected IPECommands getCommandSession() {
        return this.m_cmdSession;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRosterDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (this.m_guid == null) {
            this.fillInFromCEMP();
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "Value");
        if (this.m_distinguishedName != null) {
            theBuffer.append("\n" + INDENT_1 + "DistinguishedName" + "=\"" + VWXMLHandler.toXMLString(this.m_distinguishedName) + "\"");
        }
        if (this.m_displayName != null) {
            theBuffer.append("\n" + INDENT_1 + "DisplayName" + "=\"" + VWXMLHandler.toXMLString(this.m_displayName) + "\"");
        }
        if (this.m_guid != null) {
            theBuffer.append("\n" + INDENT_1 + "GUID" + "=\"" + VWXMLHandler.toXMLString(this.m_guid) + "\"");
        }
        if (this.m_userId != -1L) {
            theBuffer.append("\n" + INDENT_1 + "Id" + "=\"" + Long.toString(this.m_userId) + "\"");
        }
        if (this.m_secDomainName != null) {
            theBuffer.append("\n" + INDENT_1 + "DomainName" + "=\"" + VWXMLHandler.toXMLString(this.m_secDomainName) + "\"");
        }
        if (this.m_type != 0) {
            theBuffer.append("\n" + INDENT_1 + "IsGroup" + "=\"" + VWXMLHandler.booleanToString(this.m_type == 2) + "\"");
        }
        theBuffer.append(">");
        theBuffer.append(VWXMLHandler.toXMLString(this.m_participantName));
        theBuffer.append("</Value>\n");
    }
}

